% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{ham}
\alias{ham}
\title{Conjoint Study of Dry Cured Ham}
\format{
\describe{
\item{Consumer}{factor with 81 levels: numbering identifying consumers.}
\item{Product}{factor with four levels.}
\item{Informed.liking}{numeric: hedonic liking for the products.}
\item{Information}{factor with two levels.}
\item{Gender}{factor with two levels.}
\item{Age}{numeric: age of Consumer.}
}
}
\usage{
data(ham)
}
\description{
One of the purposes of the study was to investigate the effect of
information given to the consumers measured in hedonic liking for the
hams. Two of the hams were Spanish and two were Norwegian, each origin
representing different salt levels and different aging time. The
information about origin was given in such way that both true and
false information was given. Essentially a 4x2 design with 4 samples
and 2 information levels. A total of 81 Consumers participated in the
study.
}
\examples{

# Simple model for the ham data:
fm <- lmer(Informed.liking ~ Product*Information + (1|Consumer) , data=ham)

# Anova table for the fixed effects:
anova(fm)

\dontrun{
# Fit 'big' model:
fm <- lmer(Informed.liking ~ Product*Information*Gender*Age +
             + (1|Consumer) + (1|Consumer:Product) +
             (1|Consumer:Information),
           data=ham)
step_fm <- step(fm)
step_fm # Display elimination results
final_fm <- get_model(step_fm)
}

}
\references{
T. Næs, V. Lengard, S. Bølling Johansen, M. Hersleth (2010)
Alternative methods for combining design variables and consumer preference
with information about attitudes and demographics in conjoint analysis,
\emph{Food Quality and Preference}, 10-4, 368-378, ISSN 0950-3293,
\doi{10.1016/j.foodqual.2009.09.004}.
}
\keyword{datasets}
