% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltc_functions.R
\docType{data}
\name{ltc}
\alias{ltc}
\alias{palettes}
\title{List of colour palettes}
\format{
An object of class \code{list} of length 31.
}
\usage{
palettes

ltc(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Character or unquoted name. The name of the desired palette.}

\item{n}{Integer. The number of colors you want from the palette.
If omitted, it uses all colors from the palette.}

\item{type}{The type of palette. Either "discrete" or "continuous".}
}
\value{
A vector of hex color codes with class "ltc"
}
\description{
A list containing predefined colour palettes with artistic backstories.

This function provides the desired colour palette by name.
You can call it with or without quotes: ltc(paloma) or ltc("paloma")
}
\details{
ltc: A Collection of Art-inspired Colour Palettes

This package provides a collection of color palettes inspired by
art, nature, and personal preferences. Each palette has a backstory,
providing context and meaning to the colors.
}
\examples{
# Load a palette (with or without quotes)
ltc(paloma)
ltc("maya")

# Select first 3 colors
ltc(maya, n = 3)

# Generate continuous palette
ltc(remains, n = 10, type = "continuous")
}
\keyword{datasets}
