% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wwtp_functions.R
\name{wwtp_to_spatial}
\alias{wwtp_to_spatial}
\title{Convert WWTP Data to Spatial Format}
\usage{
wwtp_to_spatial(wwtp_data, crs = 4326)
}
\arguments{
\item{wwtp_data}{Data frame. WWTP data with Lat/Long coordinates}

\item{crs}{Numeric. Coordinate reference system (default: 4326 for WGS84)}
}
\value{
sf object with WWTP facilities as point geometries
}
\description{
Convert WWTP data frame to sf spatial object
}
\examples{
\donttest{
# Load and convert to spatial format
wwtp_data <- load_builtin_wwtp("nitrogen", 2016)
wwtp_clean_data <- wwtp_clean_data(wwtp_data, "nitrogen")
wwtp_sf <- wwtp_to_spatial(wwtp_clean_data)

# Convert and transform to analysis CRS (without using pipe operator)
wwtp_sf <- wwtp_to_spatial(wwtp_clean_data)
wwtp_sf_transformed <- sf::st_transform(wwtp_sf, 5070)  # Albers Equal Area Conic
}
}
