% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_h3.R
\name{add_h3}
\alias{add_h3}
\title{Add h3}
\usage{
add_h3(
  map,
  data = get_map_data(map),
  hexagon = NULL,
  stroke_colour = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  fill_colour = NULL,
  fill_opacity = NULL,
  elevation = NULL,
  tooltip = NULL,
  auto_highlight = FALSE,
  elevation_scale = 1,
  highlight_colour = "#AAFFFFFF",
  light_settings = list(),
  layer_id = NULL,
  id = NULL,
  palette = "viridis",
  na_colour = "#808080FF",
  legend = FALSE,
  legend_options = NULL,
  legend_format = NULL,
  update_view = TRUE,
  focus_layer = FALSE,
  transitions = NULL
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be
EPSG:4326 (WGS 84) coordinate system}

\item{hexagon}{column of \code{data} containing the hexagon indexes}

\item{stroke_colour}{variable of \code{data} or hex colour for the stroke. If used,
\code{elevation} is ignored.
If using a hex colour, use either a single value, or a column of hex colours  on \code{data}}

\item{stroke_width}{width of the stroke in meters. If used, \code{elevation} is ignored. Default 1.}

\item{stroke_opacity}{Either a string specifying the column of \code{data}
containing the opacity of each shape, or a single value in [0,255], or [0, 1),
to be applied to all the shapes. Default 255. If a hex-string is used as the
colour, this argument is ignored and you should include the alpha on the hex string}

\item{fill_colour}{column of \code{data} or hex colour for the fill colour.
If using a hex colour, use either a single value, or a column of hex colours  on \code{data}}

\item{fill_opacity}{Either a string specifying the column of \code{data}
containing the opacity of each shape, or a single value in [0,255], or [0, 1),
to be applied to all the shapes. Default 255. If a hex-string is used as the
colour, this argument is ignored and you should include the alpha on the hex string}

\item{elevation}{the height the polygon extrudes from the map. Only available if neither
\code{stroke_colour} or \code{stroke_width} are supplied. Default 0}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{elevation_scale}{elevation multiplier.}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{light_settings}{list of light setting parameters. See \link{light_settings}}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix must have at least 5 rows, and 3 or 4 columns of values between [0, 255],
where the 4th column represents the alpha. You can use a named list to specify a different
palette for different colour options (where available),
 e.g. list(fill_colour = "viridis", stroke_colour = "inferno")}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{transitions}{list specifying the duration of transitions.}
}
\description{
The h3 layer renders hexagons from the H3 geospatial indexing system. To use
this layer you must specify \code{libraries = "h3"} within the \code{mapdeck()} call. See examples.
}
\details{
\code{add_h3} supports a data.frame with a column of h3 indexes
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for h3

list(
elevation = 0
colour = 0
)
}

\examples{
\dontrun{

## You need a valid access token from Mapbox
key <- 'abc'
set_token( key )

mapdeck(
 style = mapdeck_style("dark")
 , location = c(0, 51.3)
 , zoom = 10
 , pitch = 60
 , libraries = "h3"
 ) \%>\%
 add_h3(
   data = road_safety
   , hexagon = "hex"
   , fill_colour = "count"
   , auto_highlight = TRUE
   , legend = TRUE
   , elevation = "count"
   , elevation_scale = 20
   , palette = colourvalues::get_palette("inferno")
   )

}

}
