% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_distance}
\alias{turf_distance}
\title{Calculate distance between two features}
\usage{
turf_distance(
  proxy,
  layer_id = NULL,
  layer_id_2 = NULL,
  data = NULL,
  coordinates = NULL,
  coordinates_2 = NULL,
  units = "kilometers",
  input_id = "turf_distance_result"
)
}
\arguments{
\item{proxy}{A mapboxgl_proxy or maplibre_proxy object.}

\item{layer_id}{The ID of the first layer or source (mutually exclusive with data and coordinates).}

\item{layer_id_2}{The ID of the second layer or source (required if layer_id is used).}

\item{data}{An sf object for the first geometry (mutually exclusive with layer_id and coordinates).}

\item{coordinates}{A numeric vector of length 2 with lng/lat coordinates for the first point (mutually exclusive with layer_id and data).}

\item{coordinates_2}{A numeric vector of length 2 with lng/lat coordinates for the second point (required if coordinates is used).}

\item{units}{The units for the distance calculation. One of "meters", "kilometers", "miles", etc.}

\item{input_id}{Character string specifying the Shiny input ID suffix for storing the distance result. Default is "turf_distance_result". Result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The proxy object for method chaining.
}
\description{
This function calculates the distance between the first features of two layers or coordinates.
Note: This function only works with proxy objects as it returns a numeric value to R.
}
