% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation.R
\name{animate_plot}
\alias{animate_plot}
\alias{animate_plot.default}
\alias{animate_plot.maraca}
\alias{animate_plot.adhce}
\title{Creates and returns an animated version of the standard maraca plot.}
\usage{
animate_plot(obj, ...)

\method{animate_plot}{default}(obj, ...)

\method{animate_plot}{maraca}(
  obj,
  continuous_grid_spacing_x = NULL,
  trans = c("identity", "log", "log10", "sqrt", "reverse")[1],
  density_plot_type = c("default", "violin", "box", "scatter")[1],
  vline_type = NULL,
  remove_outliers = FALSE,
  theme = "maraca",
  anim_order = c("active", "control", "both")[3],
  gif_output = c(TRUE, FALSE)[1],
  gif_file_name = NULL,
  frames_per_step = 10,
  gif_duration = 10,
  end_duration = 20,
  speed_factor = NULL,
  anim_width = 700,
  anim_height = 500,
  ...
)

\method{animate_plot}{adhce}(
  obj,
  step_outcomes = NULL,
  last_outcome = "C",
  arm_levels = c(active = "A", control = "P"),
  continuous_grid_spacing_x = NULL,
  trans = c("identity", "log", "log10", "sqrt", "reverse")[1],
  density_plot_type = c("default", "violin", "box", "scatter")[1],
  vline_type = NULL,
  remove_outliers = FALSE,
  theme = "maraca",
  anim_order = c("active", "control", "both")[3],
  gif_output = c(TRUE, FALSE)[1],
  gif_file_name = NULL,
  gif_duration = 10,
  end_duration = 20,
  speed_factor = NULL,
  anim_width = 700,
  anim_height = 500,
  compute_win_odds = FALSE,
  step_types = "tte",
  last_type = "continuous",
  lowerBetter = FALSE,
  ...
)
}
\arguments{
\item{obj}{an object of S3 class 'maraca'}

\item{\dots}{not used}

\item{continuous_grid_spacing_x}{The spacing of the x grid to use for the
continuous section of the plot.}

\item{trans}{the transformation to apply to the x-axis scale for the last
outcome. Possible values are "identity", "log" (only for continuous
endpoint), "log10" (only for continuous endpoint), "sqrt" (only for
continuous endpoint) and "reverse". The default value is "identity".}

\item{density_plot_type}{which type of plot to display in the continuous
part of the plot. Options are "default", "violin", "box", "scatter".}

\item{vline_type}{what the vertical dashed line should represent. Accepts
"median" (only for continuous last endpoint), "mean", "none" and
NULL (default). By default (vline_type = NULL), vline_type will be
set to "median" for a continuous last endpoint and to "mean" for
a binary last endpoint.}

\item{remove_outliers}{Flag indicating for last endpoint if outliers are
supposed to be displayed. If TRUE, the outliers are removed and
only the range not including them is displayed. Only implemented
for continuous endpoints. Default value FALSE.}

\item{theme}{Choose theme to style the plot. The default theme is "maraca".
Options are "maraca", "maraca_old", "color1", "color2" and none".
For more details, check the vignette called
"Maraca Plots - Themes and Styling".}

\item{anim_order}{In what order should the treatment arms be animated?
Possible values are "active" (active arm is being animated
first), "control" (control arm is being animated first) or
"both" (both arms are being animated at the same time).
Default is "both".}

\item{gif_output}{Flag indicating if output should be rendered as gif.
Note that the 'gifski' package need to be installed in
order to create a gif output. Alternatively, if either the
'av' or 'ffmpeg' package is installed, a video file is
created. As a final alternative if no dependency is
installed, a list of image files is returned.}

\item{gif_file_name}{If gif output should be saved in file, provide file
name. If not provided (NULL), a tmp file will be created
to display gif.}

\item{frames_per_step}{The frame rate of the animation in frames/sec. Default
is 10.}

\item{gif_duration}{The length of the animation in seconds. Default is 10.}

\item{end_duration}{The amount of frames the animation pauses on the last
frame of the animation. Default is 20.}

\item{speed_factor}{This factor tries to balance the times that it takes to
animate the step outcomes towards the last outcome. If
not provided (NULL), the function tries to estimate a
number that approximately leads to a similar speed
between them. The user can try to experiment with
manually setting the number to get the best speed.}

\item{anim_width}{Width (in pixels) of the animation. Default value is 700.}

\item{anim_height}{Height (in pixels) of the animation. Default value is 500.}

\item{step_outcomes}{A vector of strings containing the outcome labels
for all outcomes displayed as part of the step function
on the left side of the plot.
The order is kept for the plot.
By default (when set to NULL) this is automatically
updated by taking the non-continuous outcomes from
the GROUP variable in alphabetical order.}

\item{last_outcome}{A single string containing the last outcome label
displayed on the right side of the plot.
Default value "C".}

\item{arm_levels}{A named vector of exactly two strings, mapping the
values used for the active and control arms to the values
used in the data. The names must be "active" and "control"
in this order. Note that this parameter only need to
be specified if you have labels different from
"active" and "control".}

\item{compute_win_odds}{If TRUE compute the win odds, otherwise (default)
don't compute them.}

\item{step_types}{The type of each outcome in the step_outcomes vector.
Can be a single string (if all outcomes of same type) or
a vector of same length as step_outcomes. Possible values
in the vector are "tte" (default) or "binary".}

\item{last_type}{A single string giving the type of the last outcome.
Possible values are "continuous" (default), "binary" or
"multinomial".}

\item{lowerBetter}{Flag for the final outcome variable, indicating if
lower values are considered better/advantageous.
This flag is need to make sure the win odds are
calculated correctly.
Default value is FALSE, meaning higher values
are considered advantageous.}
}
\value{
Depending on which dependencies are installed, a gif, video or
        list of image files are returned.
}
\description{
Creates and returns an animated version of the standard maraca plot.
}
\examples{
data(hce_scenario_a)
hce_test <- maraca(
  data = hce_scenario_a,
  step_outcomes = c("Outcome I", "Outcome II", "Outcome III", "Outcome IV"),
  last_outcome = "Continuous outcome",
  fixed_followup_days = 3 * 365,
  column_names = c(outcome = "GROUP", arm = "TRTP", value = "AVAL0"),
  arm_levels = c(active = "Active", control = "Control"),
  compute_win_odds = TRUE
)

\dontrun{
animation <- animate_plot(hce_test,
                          anim_order = "control",
                          gif_duration = 20)
}
}
