% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporalDataFunctions.R
\name{matingSummary}
\alias{matingSummary}
\title{Summarize a Mating Scene}
\usage{
matingSummary(
  scene,
  type = "auto",
  k = 1,
  compatMethod = "si_echinacea",
  as.data.frame = FALSE
)
}
\arguments{
\item{scene}{a matingScene object}

\item{type}{character. whether to do a temporal (t), spatial (s), or mating
type (mt) summary. The default is "auto" which will automatically summarize
all mating information in scene}

\item{k}{integer. Which nearest neighbor to calculate (only for type == "s")}

\item{compatMethod}{character indicating the method to use when calculating
compatiblity. Defaults to "si_echinacea"}

\item{as.data.frame}{logical. If TRUE, returns summary as a dataframe.}
}
\value{
a list, list of lists, or dataframe containing summary information
including:\cr
temporal - year (year), population start date (popSt), mean individual start date
(meanSD), standard deviation of start (sdSD), mean duration (meanDur),
standard deviation of duration (sdDur), peakDay - day(s) on which highest
number of individuals were receptive (peak), mean end date (meanED),
standard deviation of end date (sdED), population end date (popEnd)\cr
spatial - minimum x (minX), minimum y (minY), maximum x (maxX),
maximum y (maxY), average distance to kth nearest neighbor as specified
by k (k<n> where n is the input for k)\cr
compatibility - number of mating types (nMatType), average number of
compatible mates (meanComp)\cr
If scene is a multi-year matingScene, then the output will be a list
of lists, one list for each year.
If \code{as.data.frame = TRUE}, the output will be a dataframe with columns containing summary information and, if applicable, an 'id' column identifying what portion of the matingSummary object it summarized. If the scene is a multi-year matingScene, then the output will be a list of dataframes, one list for each year.
}
\description{
Create a summary of information contained within a matingScene object.
}
\examples{
eelr <- makeScene(ech2012, startCol = "firstDay", endCol = "lastDay",
  xCol = "Ecoord", yCol = "Ncoord", idCol = "tagNo")
eelrSum <- matingSummary(eelr)
eelrSum[c("minX", "minY", "maxX", "maxY")]
}
