% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symMat.R
\name{symMat}
\alias{symMat}
\title{Create a Symmetric Matrix from a Vector}
\usage{
symMat(x, diag = TRUE, byrow = FALSE, names = FALSE)
}
\arguments{
\item{x}{A numeric vector used to fill the upper or lower triangle of the matrix.}

\item{diag}{Logical. If \code{TRUE} (the default), the diagonals of the created matrix are replaced
by elements of x; otherwise, the diagonals of the created matrix are replaced by "1".}

\item{byrow}{Logical. If \code{FALSE} (the default), the created matrix is filled by columns;
otherwise, the matrix is filled by rows.}

\item{names}{Either a logical or a character vector of names for the rows and columns of the matrix.
If \code{FALSE}, no names are assigned; if \code{TRUE}, rows and columns are named
\code{X1}, \code{X2}, ... .}
}
\value{
A symmetric square matrix based on column major ordering of the elements in \code{x}.
}
\description{
Creates a square symmetric matrix from a vector.
}
\examples{
symMat(1:6)
symMat(1:6, byrow=TRUE)
symMat(5:0, diag=FALSE)
}
\author{
Originally from \code{metaSEM::vec2symMat}, Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>; modified by Michael Friendly
}
