% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UniformCrossOverOnDoublesUsingBytes}
\alias{UniformCrossOverOnDoublesUsingBytes}
\title{Uniform Crossover operation on the two vectors of doubles using their byte representations}
\usage{
UniformCrossOverOnDoublesUsingBytes(d1, d2)
}
\arguments{
\item{d1}{A vector of doubles of the first parent}

\item{d2}{A vector of doubles of the second parent}
}
\value{
List of two double vectors of offspring
}
\description{
This function is a C++ wrapper for crossing-over of two double vectors of candidate solutions using their byte representations
}
\examples{
d1 <- runif(3)
d2 <- runif(3)
offspring <- UniformCrossOverOnDoublesUsingBytes(d1,d2)
print("Parents:")
print(d1)
print(d2)
print("Offspring:")
print(offspring[[1]])
print(offspring[[2]])
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
OnePointCrossOver

OnePointCrossOverOnDoublesUsingBytes
}

