% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-loo-waic.R
\name{loo-waic}
\alias{loo-waic}
\alias{loo.measr::measrdcm}
\alias{waic.measr::measrdcm}
\alias{loo_compare.measr::measrdcm}
\title{Relative fit for Bayesian models}
\usage{
\method{loo}{`measr::measrdcm`}(x, ..., r_eff = NA, force = FALSE)

\method{waic}{`measr::measrdcm`}(x, ..., force = FALSE)

\method{loo_compare}{`measr::measrdcm`}(x, ..., criterion = c("loo", "waic"), model_names = NULL)
}
\arguments{
\item{x}{A \link[=dcm_estimate]{measrdcm} object.}

\item{...}{For \code{loo()} and \code{waic()}, additional arguments passed to
\code{\link[loo:loo]{loo::loo.array()}} or \code{\link[loo:waic]{loo::waic.array()}}, respectively.
For \code{loo_compare()}, additional \link[=dcm_estimate]{measrdcm} objects to be
compared to \code{x}.}

\item{r_eff}{Vector of relative effective sample size estimates for the
likelihood (\code{exp(log_lik)}) of each observation. This is related to
the relative efficiency of estimating the normalizing term in
self-normalized importance sampling when using posterior draws obtained
with MCMC. If MCMC draws are used and \code{r_eff} is not provided then
the reported PSIS effective sample sizes and Monte Carlo error estimates
can be over-optimistic. If the posterior draws are (near) independent then
\code{r_eff=1} can be used. \code{r_eff} has to be a scalar (same value is used
for all observations) or a vector with length equal to the number of
observations. The default value is 1. See the \code{\link[loo:relative_eff]{relative_eff()}} helper
functions for help computing \code{r_eff}.}

\item{force}{If the \acronym{LOO} criterion has already been added to the
model object with \code{\link[=add_criterion]{add_criterion()}}, should it be recalculated. Default is
\code{FALSE}.}

\item{criterion}{The name of the criterion to be extracted from the
\code{x} for comparison.}

\item{model_names}{Names given to each provided model in the comparison
output. If \code{NULL} (the default), the names will be parsed from the names of
the objects passed for comparison.}
}
\value{
For \code{loo()} and \code{waic()}, the information criteria returned by
\code{\link[loo:loo]{loo::loo.array()}} or \code{\link[loo:waic]{loo::waic.array()}}, respectively.

For \code{loo_compare()}, the criterion comparison returned by
\code{\link[loo:loo_compare]{loo::loo_compare()}}.
}
\description{
For models estimated with MCMC, relative model fit comparisons can be made
using the LOO-CV or WAIC indicates (Vehtari et al., 2017). These functions
are wrappers for the \link[loo:loo-package]{loo} package. See the loo package
\href{https://mc-stan.org/loo/articles/}{vignettes} for details on the
implementation.
}
\references{
Vehtari, A., Gelman, A., & Gabry, J. (2017). Practical Bayesian
model evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing, 27}(5), 1413-1432.
\doi{10.1007/s11222-016-9696-4}
}
\concept{Bayesian}
