% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pbtick}
\alias{pbtick}
\title{Update progress if the progress bar is not \code{NULL}.}
\usage{
pbtick(pb, message = NULL)
}
\arguments{
\item{pb}{a progress bar created with \code{progressr}.}

\item{message}{optional message to report (default: \code{NULL}).}
}
\description{
This allows for flexible code that only initializes a progress bar if the
\code{progressr} package is installed.
}
\examples{
\dontrun{
f <- function() {
  if (isTRUE(check_packages_installed("progressr"))) {
    pb <- progressr::progressor(steps = 5, message = "looping")
  } else {
    pb <- NULL
  }
  for (i in 1:5) {
    pbtick(pb)
    Sys.sleep(0.5)
  }
}
progressr::with_progress(
  f()
)
}
}
\author{
Kelly Sovacool \email{sovacool@umich.edu}
}
\keyword{internal}
