#' Sample Data
#'
#' A sample tibble demonstrating the expected input structure for the I-Score pipeline. It includes the platforms of the Republican and Democratic parties from 1948–2024 as well as those of all minor parties that won more than 0.5% of the presidential vote in a given election between those years. Minor parties that won more than 0.5% of the vote in consecutive elections are represented by a single entry spanning those elections. The platform text is that of the election in which the party achieved its highest vote share.
#'
#' that the package's user would build and feed into the pipeline, containing the platforms of the Republican and Democratic parties from 1948-2024 as well as the platforms of the minor parties that won more than 0.5% of the presidential popular vote in a given election.
#'
#' @format A tibble with 53 rows and 4 columns:
#' \describe{
#'   \item{party}{Character column. The party's name (this column must be unique for each platform, e.g., "Democratic Party 1992").}
#'   \item{text}{Character column. The full text of each platform.}
#'   \item{minor_party}{Logical column. Whether the party is a minor party.}
#'   \item{major_party_platforms}{List column. Only required for minor parties. A list containing a list for each major party, each of which contains: before (Character. The name (as listed in this tibble's `party` column) of the major party's platform that precedes the minor party), `after` (Character. The name (as listed in this tibble's `party` column) of the major party's platform that follows the minor party), and `weight` (Numeric. The weight assigned to the major party)}
#' }
"sample_data"
