% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_helper_functions.R
\name{calculate_bootstrap_ci}
\alias{calculate_bootstrap_ci}
\title{Calculate Bootstrap Confidence Intervals for R Estimates}
\usage{
calculate_bootstrap_ci(
  incidence,
  si_prob,
  dates,
  si_mean,
  si_sd,
  si_dist,
  smoothing,
  n_bootstrap,
  conf_level
)
}
\arguments{
\item{incidence}{numeric vector; daily case counts}

\item{si_prob}{numeric matrix; serial interval probability matrix}

\item{dates}{vector; dates corresponding to incidence data}

\item{si_mean}{numeric; mean of the serial interval distribution}

\item{si_sd}{numeric; standard deviation of the serial interval distribution}

\item{si_dist}{character; distribution type, either "gamma" or "normal"}

\item{smoothing}{integer; window size for temporal smoothing}

\item{n_bootstrap}{integer; number of bootstrap samples to generate}

\item{conf_level}{numeric; confidence level (between 0 and 1)}
}
\value{
named list with confidence interval bounds:
\itemize{
\item \code{r_lower, r_upper}: Confidence intervals for raw R estimates
\item \code{r_corrected_lower, r_corrected_upper}: Confidence intervals for corrected R estimates
}
}
\description{
Generates bootstrap confidence intervals for reproduction number estimates by
resampling the incidence data multiple times and calculating quantiles of the
resulting R distributions.
}
