% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/molaR_Clean.R
\name{molaR_Clean}
\alias{molaR_Clean}
\title{Clean up problem ply files}
\usage{
molaR_Clean(plyFile, cleanType = "Both", verbose = TRUE)
}
\arguments{
\item{plyFile}{An object of classes 'mesh3d' and 'shape3d'}

\item{cleanType}{String with three arguments defining what to clean: Vertices,
Faces, or Both. Defaults to Both.}

\item{verbose}{Logical indicating if the function should report changes to ply}
}
\description{
Function will remove floating verticies, and faces with zero
area. These can cause issues when using molaR's primary
functions of DNE, RFI, and OPC
}
\details{
This function cleans up problematic ply files. Some
smoothed files will have faces of zero area, or floating
vertices. DNE and OPC cannot be calculated on these files.
Running the plys through this function will allow those
calculations to be made.
}
\examples{
Tooth <- molaR_Clean(Tooth)
}
