% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quiz-xml.R
\name{moodlequiz_xml}
\alias{moodlequiz_xml}
\title{Generate Moodle Quiz XML Output for R Markdown}
\usage{
moodlequiz_xml(
  replicate = "",
  self_contained = TRUE,
  extra_dependencies = NULL,
  theme = NULL,
  includes = NULL,
  lib_dir = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{replicate}{A character string specifying the how many replications of the quiz should be produced.}

\item{self_contained}{Logical. If \code{TRUE}, the output document will be self-contained,
embedding resources directly into the file. Defaults to \code{TRUE}.}

\item{extra_dependencies}{Additional dependencies to include in the output. These can be
specified as an \code{html_dependency} object or a list of such objects.}

\item{theme}{A character string specifying the theme for the output. This can be a standard
theme name or a custom CSS file.}

\item{includes}{Additional content to include in the output. This should be a list of
named elements, such as \code{in_header}, \code{before_body}, and \code{after_body}.}

\item{lib_dir}{Directory to copy library files for the output. If \code{NULL}, no library files
are copied.}

\item{md_extensions}{A character string specifying Markdown extensions to be passed to Pandoc.}

\item{pandoc_args}{Additional arguments to pass to Pandoc.}

\item{...}{Additional arguments passed to \code{\link[bookdown:html_document2]{bookdown::html_document2()}}}
}
\value{
An R Markdown output format object.
}
\description{
This function is intended for internal generation of the XML output.
It is strongly recommended that you use the \verb{[moodlequiz::moodlequiz()]}
output format, which provides a higher-level interface for creating
Moodle-compatible quizzes.
}
\seealso{
\code{\link[=moodlequiz]{moodlequiz()}}
}
\keyword{internal}
