% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{print.substitution}
\alias{print.substitution}
\title{Print a Summary for a \code{substitution} object}
\usage{
\method{print}{substitution}(x, ...)
}
\arguments{
\item{x}{A \code{substitution} object.}

\item{...}{Additional arguments to be passed to to method \code{summary} of \code{substitution}.}
}
\description{
Print a Summary for a \code{substitution} object
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  ## fit a model with compositional predictor at between and between-person levels
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
  formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                     wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")

  subm <- substitution(object = m, delta = 5)
  print(subm)
}}
}
\seealso{
\code{\link{summary.substitution}}
}
