% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv_generic}
\alias{cv_generic}
\title{Generic cross-validation engine}
\usage{
cv_generic(
  data,
  folds,
  .fit_fun,
  .measure_fun,
  fit_args = list(),
  measure_args = list(),
  backend = c("serial", "future"),
  ...
)
}
\arguments{
\item{data}{A matrix or data.frame of shape (n x p).}

\item{folds}{A list of folds, each a list with \code{$train} and \code{$test}.}

\item{.fit_fun}{Function: signature \code{function(train_data, ...)\{\}}. Returns a fitted model.}

\item{.measure_fun}{Function: signature \code{function(model, test_data, ...)\{\}}. Returns a tibble or named list/vector of metrics.}

\item{fit_args}{A list of additional named arguments passed to \code{.fit_fun}.}

\item{measure_args}{A list of additional named arguments passed to \code{.measure_fun}.}

\item{backend}{Character string: "serial" (default) or "future" for parallel execution using the \code{future} framework.}

\item{...}{Currently ignored (arguments should be passed via \code{fit_args} or \code{measure_args}).}
}
\value{
A tibble with columns:
\item{fold}{integer fold index}
\item{model}{list of fitted models}
\item{metrics}{list of metric tibbles/lists}
}
\description{
For each fold (train/test indices):
\enumerate{
\item Subset \code{data[train, ]}
\item Fit a model with \code{.fit_fun(train_data, ...)}
\item Evaluate with \code{.measure_fun(model, test_data, ...)}
}
}
