% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsc.R
\name{plsc}
\alias{plsc}
\title{Partial Least Squares Correlation (PLSC)}
\usage{
plsc(
  X,
  Y,
  ncomp = NULL,
  preproc_x = standardize(),
  preproc_y = standardize(),
  ...
)
}
\arguments{
\item{X}{Numeric matrix of predictors (n x p_x).}

\item{Y}{Numeric matrix of outcomes/behaviors (n x p_y). Must have the same
number of rows as \code{X}.}

\item{ncomp}{Number of latent variables to return. Defaults to
\code{min(nrow(X), ncol(X), ncol(Y))}.}

\item{preproc_x}{Preprocessor for the X block (default: \code{standardize()}).
Use \code{center()} if you want covariance-based PLSC instead of correlation.}

\item{preproc_y}{Preprocessor for the Y block (default: \code{standardize()}).}

\item{...}{Extra arguments stored on the returned object.}
}
\value{
A \code{cross_projector} with class \code{"plsc"} containing
\itemize{
\item \code{vx}, \code{vy}: X and Y loading/weight matrices.
\item \code{sx}, \code{sy}: subject scores for X and Y blocks.
\item \code{singvals}: singular values of \eqn{C_{XY}} (strength of each LV).
\item \code{explained_cov}: proportion of cross-block covariance per LV.
\item \code{preproc_x}, \code{preproc_y}: fitted preprocessors for reuse.
}
}
\description{
Reference implementation of symmetric brain-behavior PLS (a.k.a. Behavior PLSC).
It finds paired weight vectors for X and Y that maximize their cross-block
covariance, obtained from the SVD of the cross-covariance (or correlation)
matrix \eqn{C_{XY} = X^\top Y / (n-1)}.
}
\examples{
set.seed(1)
X <- matrix(rnorm(80), 20, 4)
Y <- matrix(rnorm(60), 20, 3)
fit <- plsc(X, Y, ncomp = 3)
fit$singvals
}
