% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composed_projector.R
\name{reconstruct.composed_projector}
\alias{reconstruct.composed_projector}
\title{Reconstruct Data from Scores using a Composed Projector}
\usage{
\method{reconstruct}{composed_projector}(x, scores, comp = NULL, rowind = NULL, colind = NULL, ...)
}
\arguments{
\item{x}{A \code{composed_projector} object.}

\item{scores}{A numeric matrix of scores (observations x components) in the
final latent space of the composed projector.}

\item{comp}{Numeric vector of component indices (columns of \code{scores}, rows of
\code{inverse_projection}) to use for reconstruction. Defaults to all components.}

\item{rowind}{Numeric vector of row indices (observations in \code{scores}) to
reconstruct. Defaults to all rows.}

\item{colind}{Numeric vector of original variable indices (columns of the final
reconstructed matrix) to return. Defaults to all original variables.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A matrix representing the reconstructed data, ideally in the original
data space.
}
\description{
Maps scores from the final latent space back towards the original input space
using the composed projector's combined inverse projection. Requires scores
to be provided explicitly.
}
\details{
Attempts to apply the \code{reverse_transform} of the \emph{first} stage's preprocessor
to return data in the original units. If the first stage preprocessor is
unavailable or invalid, a warning is issued, and data is returned in the
(potentially) preprocessed space of the first stage.
}
