% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate_with.R
\name{relocate_with}
\alias{relocate_with}
\title{Relocate columns}
\usage{
relocate_with(
  .data,
  .fn,
  .cols = everything(),
  .before = NULL,
  .after = NULL,
  ...
)
}
\arguments{
\item{.data}{A \code{data.frame} or  \code{tibble}.}

\item{.fn}{A function to reorder \code{.cols}.}

\item{.cols}{Columns to move}

\item{.before, .after}{Destination of columns. If both selected, errors. If
neither, moves to right of first selected column.}

\item{...}{additional arguments to pass to \code{.fn}}
}
\value{
And object with same type as \code{.data}.
}
\description{
Relocate columns
}
\examples{
data(sd)
sd |> relocate_with(sort)
}
