% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ard.R
\name{make_ard}
\alias{make_ard}
\title{Generate simulated ARD}
\usage{
make_ard(
  n_i = 500,
  n_k = 20,
  N = 1e+06,
  p = 0,
  p_global_nonzero = 0,
  p_local_nonzero = 0,
  group_corr = FALSE,
  degree_corr = FALSE,
  family = c("poisson", "nbinomial"),
  omega_range = c(1, 5),
  alpha_mean = 5,
  alpha_sd = 0.15,
  eta = 3,
  seed = NULL
)
}
\arguments{
\item{n_i}{number of respondents (rows)}

\item{n_k}{number of groups (columns)}

\item{N}{total population size}

\item{p}{number of collected covariates}

\item{p_global_nonzero}{number of non-zero global covariates}

\item{p_local_nonzero}{number of non-zero local covariates}

\item{group_corr}{group correlation}

\item{degree_corr}{degree correlation}

\item{family}{sampling distribution}

\item{omega_range}{minimum and maximum omega for negative binomial overdispersion}

\item{alpha_mean}{mean of alphas}

\item{alpha_sd}{variance of alphas}

\item{eta}{correlation hyperparameter for LKJ prior}

\item{seed}{random seed}
}
\value{
simulated ARD along with all true parameters
}
\description{
Generate simulated ARD
}
\examples{
make_ard(N = 10000, family = "poisson")
}
