% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_tables.R
\name{nhanesTables}
\alias{nhanesTables}
\title{Returns a list of table names for the specified survey group.}
\usage{
nhanesTables(
  data_group,
  year,
  nchar = 128,
  details = FALSE,
  namesonly = FALSE,
  includerdc = FALSE
)
}
\arguments{
\item{data_group}{The type of survey (DEMOGRAPHICS, DIETARY, EXAMINATION, LABORATORY, QUESTIONNAIRE).
Abbreviated terms may also be used: (DEMO, DIET, EXAM, LAB, Q).}

\item{year}{The year in yyyy format where 1999 <= yyyy.}

\item{nchar}{Truncates the table description to a max length of nchar.}

\item{details}{If TRUE then a more detailed description of the tables is returned (default=FALSE).}

\item{namesonly}{If TRUE then only the table names are returned (default=FALSE).}

\item{includerdc}{If TRUE then RDC only tables are included in list (default=FALSE).}
}
\value{
Returns a data frame that contains table attributes. If namesonly=TRUE,
then a character vector of table names is returned.
}
\description{
Enables quick display of all available tables in the survey group.
}
\details{
Function nhanesTables retrieves a list of tables and a 
description of their contents from the NHANES website. This provides
a convenient way to browse the available tables. NULL is returned when an
HTML read error is encountered.
}
\examples{
exam = nhanesTables('EXAM', 2007)
dim(exam)
\donttest{
lab = nhanesTables('LAB', 2009, details=TRUE, includerdc=TRUE)
dim(lab)
q = nhanesTables('Q', 2005, namesonly=TRUE)
length(q)
diet = nhanesTables('DIET', 'P')
dim(diet)
exam = nhanesTables('EXAM', 'Y')
dim(exam)
}
}
