% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_sens_params.R
\name{sim_sens_1cmpt_mm}
\alias{sim_sens_1cmpt_mm}
\title{Parameter sweeping for a one-compartment Michaelis-Menten model}
\usage{
sim_sens_1cmpt_mm(
  dat,
  sim_vmax = list(mode = "auto", values = NULL, est.cl = NULL),
  sim_km = list(mode = "auto", values = NULL),
  sim_vd = list(mode = "manual", values = NULL),
  sim_ka = list(mode = "manual", values = NULL),
  route = c("iv", "oral"),
  verbose = TRUE
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{sim_vmax}{List specifying Vmax:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if mode = "manual"
\item est.cl: required if mode = "auto"
}}

\item{sim_km}{List specifying Km:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if mode = "manual"
}}

\item{sim_vd}{List specifying Vd:
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_ka}{List specifying Ka (oral route only):
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{route}{Dosing route, either "iv" or "oral". Default is "iv".}

\item{verbose}{Logical (default = TRUE).
Controls whether progress information is displayed during parameter sweeping.
When TRUE, a dynamic progress bar is shown using the \code{progressr} package to
indicate simulation status and elapsed time.
When FALSE, progress output is suppressed and the function runs silently.}
}
\value{
A data frame containing parameter combinations and model fit metrics.
}
\description{
Performs parameter sweeping by varying pharmacokinetic parameters in a
one-compartment model with Michaelis-Menten elimination.
}
\details{
The function generates a parameter grid and performs model fitting for each
combination using \code{Fit_1cmpt_mm_iv}. Parameters can be specified manually or
automatically derived. Model predictions and fit metrics are computed for each
simulation to assess parameter sensitivity.
}
\examples{
\donttest{
# Example: IV dosing scenario with automatic Vmax and Km
out <- sim_sens_1cmpt_mm(
  dat = Bolus_1CPTMM[Bolus_1CPTMM$ID<50,],
  sim_vmax = list(mode = "auto", est.cl = 4),
  sim_km   = list(mode = "auto"),
  sim_vd   = list(mode = "manual", values = 70),
  sim_ka   = list(mode = "manual", values = NA),
  route = "iv"
)
head(out[out$rRMSE2==min(out$rRMSE2),])
}
}
\seealso{
\code{\link{Fit_1cmpt_mm_iv}}, \code{\link{Fit_1cmpt_mm_oral}}
}
\author{
Zhonghui Huang
}
