% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{BlocksChildrenEndpoint}
\alias{BlocksChildrenEndpoint}
\title{R6 Class for Blocks children endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all block children operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$blocks$children}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- append children to a block
\dontshow{notionapi::vcr_example_start("notion-blocks-children-append")}
notion$blocks$children$append(
  block_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba",
  children = list(
    # add a level 2 heading called "Test Heading"
    list(
      object = "block",
      heading_2 = list(
        rich_text = list(list(
          text = list(content = "Test Heading")
        ))
      )
    )
  )
)
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve children of a block
\dontshow{notionapi::vcr_example_start("notion-blocks-children-retrieve")}
notion$blocks$children$retrieve("23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba")
\dontshow{notionapi::vcr_example_end()}

# ----- iterate through paginated results
\dontrun{
start_cursor <- NULL
has_more <- FALSE
resps <- list()
i <- 1

while (has_more) {
  resps[[i]] <- notion$blocks$children$retrieve(
    "2926b407e3c44b49a1830609abe6744f",
    start_cursor
  )
  has_more <- resps[[i]][["has_more"]]
  start_cursor <- resps[[i]][["next_cursor"]]
  i <- i + 1
}
}
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BlocksChildrenEndpoint-new}{\code{BlocksChildrenEndpoint$new()}}
\item \href{#method-BlocksChildrenEndpoint-retrieve}{\code{BlocksChildrenEndpoint$retrieve()}}
\item \href{#method-BlocksChildrenEndpoint-append}{\code{BlocksChildrenEndpoint$append()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksChildrenEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksChildrenEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise block children endpoint.
Not to be called directly, e.g., use \code{notion$pages$children} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksChildrenEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksChildrenEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksChildrenEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve a block's children
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksChildrenEndpoint$retrieve(block_id, start_cursor = NULL, page_size = 100)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{String (required). The ID for a Notion block.}

\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/get-block-children}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BlocksChildrenEndpoint-append"></a>}}
\if{latex}{\out{\hypertarget{method-BlocksChildrenEndpoint-append}{}}}
\subsection{Method \code{append()}}{
Append block children
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BlocksChildrenEndpoint$append(block_id, children, after = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{String (required). The ID for a Notion block.}

\item{\code{children}}{List of lists (JSON array) (required). Block objects to append as children to the block.}

\item{\code{after}}{Character. The ID of the existing block after which the new children are appended.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/patch-block-children}{Endpoint documentation}
}

}
}
