% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{CommentsEndpoint}
\alias{CommentsEndpoint}
\title{R6 Class for Comments Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all comments operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$comments}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- create comment
\dontshow{notionapi::vcr_example_start("notion-comments-create")}
notion$comments$create(
  list(page_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba"),
  rich_text = list(list(
    text = list(
      content = "Hello world"
    )
  ))
)
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve comments
\dontshow{notionapi::vcr_example_start("notion-comments-retrieve")}
notion$comments$retrieve(block_id = "23933ea0-c1e4-81d6-a6f6-dd5b57ad4aba")
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CommentsEndpoint-new}{\code{CommentsEndpoint$new()}}
\item \href{#method-CommentsEndpoint-create}{\code{CommentsEndpoint$create()}}
\item \href{#method-CommentsEndpoint-retrieve}{\code{CommentsEndpoint$retrieve()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommentsEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-CommentsEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise comments endpoint.
Not to be called directly, e.g., use \code{notion$comments} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommentsEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommentsEndpoint-create"></a>}}
\if{latex}{\out{\hypertarget{method-CommentsEndpoint-create}{}}}
\subsection{Method \code{create()}}{
Create a comment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommentsEndpoint$create(
  parent = NULL,
  discussion_id = NULL,
  rich_text,
  attachments = NULL,
  display_name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{List (JSON object). The parent page where comment is created. Required if \code{discussion_id} is not provided}

\item{\code{discussion_id}}{Character. The ID of the discussion thread for the comment. Required if \code{parent} is not provided.}

\item{\code{rich_text}}{List of lists (JSON array) (required). \href{https://developers.notion.com/reference/rich-text}{Rich text object(s)} representing the comment content.}

\item{\code{attachments}}{List of lists (JSON array). Attachments to include in the comment.}

\item{\code{display_name}}{Named list (JSON object). Custom display name of the comment.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/create-a-comment}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CommentsEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-CommentsEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve comments for a block
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CommentsEndpoint$retrieve(block_id, start_cursor = NULL, page_size = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block_id}}{Character. The ID for a Notion block.}

\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/retrieve-a-comment}{Endpoint documentation}
}

}
}
