% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{UsersEndpoint}
\alias{UsersEndpoint}
\title{R6 Class for Users Endpoint}
\value{
A list containing the parsed API response.
}
\description{
Handle all users operations in the Notion API

\strong{Note:} Access this endpoint through the client instance, e.g., \code{notion$users}. Not to be instantiated directly.
}
\examples{
\dontshow{if (notion_token_exists()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
notion <- notion_client()

# ----- list all users
\dontshow{notionapi::vcr_example_start("notion-users-list")}
notion$users$list()
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve a user
\dontshow{notionapi::vcr_example_start("notion-users-retrieve")}
notion$users$retrieve(user_id = "fda12729-108d-4eb5-bbfb-a8f0886794d1")
\dontshow{notionapi::vcr_example_end()}

# ----- retrieve the bot User associated with the API token
\dontshow{notionapi::vcr_example_start("notion-users-me")}
notion$users$me()
\dontshow{notionapi::vcr_example_end()}
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UsersEndpoint-new}{\code{UsersEndpoint$new()}}
\item \href{#method-UsersEndpoint-list}{\code{UsersEndpoint$list()}}
\item \href{#method-UsersEndpoint-retrieve}{\code{UsersEndpoint$retrieve()}}
\item \href{#method-UsersEndpoint-me}{\code{UsersEndpoint$me()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UsersEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-UsersEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Initialise users endpoint.
Not to be called directly, e.g., use \code{notion$users} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UsersEndpoint$new(client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Notion Client instance}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UsersEndpoint-list"></a>}}
\if{latex}{\out{\hypertarget{method-UsersEndpoint-list}{}}}
\subsection{Method \code{list()}}{
List all users
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UsersEndpoint$list(start_cursor = NULL, page_size = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start_cursor}}{Character. For pagination. If provided, returns results starting from this cursor.
If NULL, returns the first page of results.}

\item{\code{page_size}}{Integer. Number of items to return per page (1-100). Defaults to 100.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/get-users}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UsersEndpoint-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-UsersEndpoint-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieve a user
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UsersEndpoint$retrieve(user_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_id}}{Character (required). The ID of the user to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\href{https://developers.notion.com/reference/get-user}{Endpoint documentation}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UsersEndpoint-me"></a>}}
\if{latex}{\out{\hypertarget{method-UsersEndpoint-me}{}}}
\subsection{Method \code{me()}}{
Retrieve the bot User associated with the API token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UsersEndpoint$me()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\href{https://developers.notion.com/reference/get-self}{Endpoint documentation}
}

}
}
