% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntfy.R
\name{ntfy_send}
\alias{ntfy_send}
\title{Send a Notification}
\usage{
ntfy_send(
  message = "test",
  title = NULL,
  tags = NULL,
  priority = 3,
  actions = NULL,
  click = NULL,
  image = NULL,
  attach = NULL,
  filename = NULL,
  delay = NULL,
  email = NULL,
  topic = ntfy_topic(),
  server = ntfy_server(),
  auth = ntfy_auth(),
  username = ntfy_username(),
  password = ntfy_password()
)
}
\arguments{
\item{message}{text to send as notification}

\item{title}{title of notification. See \url{https://docs.ntfy.sh/publish/#message-title}}

\item{tags}{text tags or emoji shortcodes from \url{https://docs.ntfy.sh/emojis/},
provided as a list}

\item{priority}{Message priority with 1=min, 3=default and 5=max. See \url{https://docs.ntfy.sh/publish/#message-priority}}

\item{actions}{Custom user action buttons for notifications. See \url{https://docs.ntfy.sh/publish/#action-buttons}}

\item{click}{Website opened when notification is clicked. See \url{https://docs.ntfy.sh/publish/#click-action}}

\item{image}{Image to include in the body of the notification. Either a \code{ggplot} object or a filename.}

\item{attach}{URL of an attachment, see attach via URL. See \url{https://docs.ntfy.sh/publish/#attach-file-from-url}}

\item{filename}{File name of the attachment}

\item{delay}{Timestamp or duration for delayed delivery}

\item{email}{E-mail address for e-mail notifications??}

\item{topic}{subscribed topic to which to send notification}

\item{server}{ntfy server}

\item{auth}{logical indicating if the topic requires password authorization}

\item{username}{username with access to a protected topic.}

\item{password}{password with access to a protected topic.}
}
\value{
a \code{\link[httr2:response]{httr2::response()}} object, invisibly.
}
\description{
Send a Notification
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# send a message to the default topic ('mytopic')
ntfy_send("test from R!")

# can use tags (emoji)
ntfy_send(message = "sending with tags!",
          tags = c(tags$cat, tags$dog)
)
\dontshow{\}) # examplesIf}
}
