% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_dop_Juvenile_cases.R
\name{nyc_dop_Juvenile_cases}
\alias{nyc_dop_Juvenile_cases}
\title{NYC DOP Juvenile Case Count By Type}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/c49b-3kmd>
}
\usage{
nyc_dop_Juvenile_cases(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing DOP Juvenile Case Count By Type data.
}
\description{
Downloads DOP Juvenile Case Count By Type data from NYC Open Data.
}
\details{
This dataset tracks the number of juvenile cases handled by the NYC Department
of Probation (DOP), broken down by case type and region. It provides insight
into trends in youth justice and probation supervision citywide.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_dop_Juvenile_cases(limit = 10)
head(small_sample)

\donttest{
nyc_dop_Juvenile_cases(limit = 5000)
nyc_dop_Juvenile_cases(filters = list(borough = "Citywide"))
}
}
