% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_midterm_demand_and_weather_data}
\alias{example_midterm_demand_and_weather_data}
\title{Example Midterm Demand and Weather Data}
\format{
A list containing two data frames:
\describe{
\item{\code{demand}}{A data frame with 1,825 rows and 10 columns, representing mid-term electricity demand data.}
\item{\code{temperature_data}}{A data frame with 1,826 rows and 22 columns, representing temperature measurements across multiple cities.}
}

\strong{Demand Data Frame}:
\describe{
\item{\code{demand.country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{demand.date}}{The date of the demand measurement (in \code{YYYY-MM-DD} format).}
\item{\code{demand.year}}{The respective year.}
\item{\code{demand.month}}{The respective month.}
\item{\code{demand.day}}{The respective day.}
\item{\code{demand.wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{demand.avg_hourly_demand}}{The average hourly electricity demand (in megawatts) for each day.}
\item{\code{demand.seasonal_avg_hourly_demand}}{The seasonal mid-term component of the demand (in megawatts).}
\item{\code{demand.weighted_temperature}}{The weighted average temperature for France on that day (in degrees Celsius).}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}

\strong{Temperature Data Frame}:
\describe{
\item{\code{date}}{The date of the temperature observation (in \code{YYYY-MM-DD} format).}
\item{\code{Paris}, \code{Marseille}, \code{Lyon}, \code{Toulouse}, \code{Nice}, \code{Nantes}, \code{Montpellier}, \code{Strasbourg}, \code{Bordeaux},\code{Cergy-Pontoise},\code{Toulon},\code{Reims}, \code{Lille},\code{15th arrondissement of Paris}, \code{20th arrondissement of Paris}, \code{18th arrondissement of Paris}, \code{19th arrondissement of Paris}, \code{13th arrondissement of Paris}}{The daily average temperature readings (in degrees Celsius) for various cities or city districts on that date.}
\item{\code{weighted_mean_temperature}}{The weighted (by share of population) mean temperature across the country for the respective date.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/ ; area population: https://wft-geo-db.p.rapidapi.com ; daily average temperatures: https://meteostat.p.rapidapi.com;
}
\usage{
example_midterm_demand_and_weather_data
}
\description{
This dataset extends the \code{\link{example_midterm_demand_data}} by adding a weighted average temperature column.
The dataset is divided into two parts: \code{demand} and \code{temperature_data}. The \code{demand} dataframe contains the added
weighted average temperature column and the other demand related data. The \code{temperature_data} dataframe contains the daily temperature observations
for the 20 most populated regions. This data is provided to show from which locations the weather data was taken.
}
\keyword{dataset}
\keyword{demand}
\keyword{midterm}
\keyword{weather-data}
