% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_replace.R
\name{body_replace_text_at_bkm}
\alias{body_replace_text_at_bkm}
\alias{body_replace_img_at_bkm}
\alias{headers_replace_text_at_bkm}
\alias{headers_replace_img_at_bkm}
\alias{footers_replace_text_at_bkm}
\alias{footers_replace_img_at_bkm}
\title{Replace text at a bookmark location}
\usage{
body_replace_text_at_bkm(x, bookmark, value)

body_replace_img_at_bkm(x, bookmark, value)

headers_replace_text_at_bkm(x, bookmark, value)

headers_replace_img_at_bkm(x, bookmark, value)

footers_replace_text_at_bkm(x, bookmark, value)

footers_replace_img_at_bkm(x, bookmark, value)
}
\arguments{
\item{x}{a docx device}

\item{bookmark}{bookmark id}

\item{value}{the replacement string, of type character}
}
\description{
Replace text content enclosed in a bookmark
with different text. A bookmark will be considered as valid if enclosing words
within a paragraph; i.e., a bookmark along two or more paragraphs is invalid,
a bookmark set on a whole paragraph is also invalid, but bookmarking few words
inside a paragraph is valid.
}
\examples{
library(officer)

doc <- read_docx()
doc <- body_add_par(doc, "a paragraph to replace", style = "centered")
doc <- body_bookmark(doc, "text_to_replace")
doc <- body_replace_text_at_bkm(doc, "text_to_replace", "new text")


# demo usage of bookmark and images ----
template <- system.file(package = "officer", "doc_examples/example.docx")

img.file <- file.path(R.home("doc"), "html", "logo.jpg")

doc <- read_docx(path = template)
doc <- headers_replace_img_at_bkm(
  x = doc,
  bookmark = "bmk_header",
  value = external_img(src = img.file, width = .53, height = .7)
)
doc <- footers_replace_img_at_bkm(
  x = doc,
  bookmark = "bmk_footer",
  value = external_img(src = img.file, width = .53, height = .7)
)
print(doc, target = tempfile(fileext = ".docx"))
}
