% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{harsm_invlink}
\alias{harsm_invlink}
\title{The inverse link for the softmax.}
\usage{
harsm_invlink(eta, mu = smax(eta, g), g = NULL)
}
\arguments{
\item{eta}{a vector of the odds.
Must be the same length as \code{g} if \code{g} is given.}

\item{mu}{a vector of the probabilities. Should sum to one,
at least per group.
Should be the same size as \code{g} if given.
If both \code{mu} and \code{eta} are given, a warning
is issued, and the \code{mu} is used.}

\item{g}{a vector giving the group indices. If \code{NULL},
then we assume only one group is in consideration.}
}
\value{
a vector of the ranks.
}
\description{
The inverse link function for the softmax. This function
takes the group-wise probabilities, \eqn{\mu}, and computes
the expected ranks within each group under the Harville
model. That is, it is a groupwise computation of
the \code{\link{erank}} function.
}
\examples{

mus <- runif(12)
mus <- mus / sum(mus)
harsm_invlink(mus)

harsm_invlink(mus,c(rep(1,6),rep(2,6)))
}
\seealso{
the ungrouped version of this, \code{\link{erank}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
