% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holidays.R
\name{oh_public_holidays}
\alias{oh_public_holidays}
\title{Get public holidays for a given country and time period}
\usage{
oh_public_holidays(country, language = "EN", start_date, end_date)
}
\arguments{
\item{country}{Country ISO code (e.g. "DE" for Germany).}

\item{language}{Language ISO code (default: "EN").}

\item{start_date}{Start date of time period (YYYY-MM-DD).}

\item{end_date}{End date of time period (YYYY-MM-DD).}
}
\value{
A data frame of holidays for a given country and time period.
}
\description{
Get public holidays for a given country and time period
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all holidays for Germany for the year 2025

oh_public_holidays(country = "DE",
                   language = "EN",
                   start_date = "2025-01-01",
                   end_date = "2025-12-31")
\dontshow{\}) # examplesIf}
}
