% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{orderly_dependency}
\alias{orderly_dependency}
\title{Declare a dependency}
\usage{
orderly_dependency(name, query, files)
}
\arguments{
\item{name}{The name of the packet to depend on}

\item{query}{The query to search for; often this will simply be
the string \code{latest}, indicating the most recent version. You may
want a more complex query here though.}

\item{files}{Files to copy from the other packet, as a character vector.
If the character vector is unnamed, the files listed are copied over
without changing their names. If the vector is named however, the names
will be used as the destination name for the files.

In either case, if you want to import a directory of files from a
packet, you must refer to the source with a trailing slash
(e.g., \code{c(here = "there/")}), which will create the local
directory \code{here/...} with files from the upstream packet
directory \verb{there/}. If you omit the slash then an error will be
thrown suggesting that you add a slash if this is what you
intended.

You can use a limited form of string interpolation in the names of
this argument; using \verb{$\{variable\}} will pick up values from
\code{envir} and substitute them into your string.  This is similar
to the interpolation you might be familiar with from
\code{glue::glue} or similar, but much simpler with no concatenation
or other fancy features supported.

Note that there is an unfortunate, but (to us) avoidable
inconsistency here; interpolation of values from your
environment in the query is done by using \code{environment:x} and in
the destination filename by doing \verb{$\{x\}}.

If you want to copy \emph{all} files from the packet, use \verb{./} (read
this as the directory of the packet).  The trailing slash is
required in order to be consistent with the rules above.}
}
\value{
Undefined
}
\description{
Declare a dependency on another packet
}
\details{
See \code{\link[=orderly_run]{orderly_run()}} for some details about how search
options are used to select which locations packets are found from,
and if any data is fetched over the network. If you are running
interactively, this will obviously not work, so you should use
\code{\link[=orderly_interactive_set_search_options]{orderly_interactive_set_search_options()}} to set the
options that this function will respond to.
}
\examples{
orderly_example_show("depends")
}
