% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ALD_stats.R
\name{marginal_treatment_effect}
\alias{marginal_treatment_effect}
\title{Marginal treatment effect from reported event counts}
\usage{
marginal_treatment_effect(ald, ref_trt = NA, comp_trt = NA, scale, family)
}
\arguments{
\item{ald}{Aggregate-level data}

\item{ref_trt}{Treatment labels reference (common; e.g. placebo)}

\item{comp_trt}{Treatment labels comparator}

\item{scale}{A scaling parameter for the calculation.}

\item{family}{A character string specifying the family distribution (e.g., "binomial").}
}
\value{
Numeric relative treatment effect.
}
\description{
Computes the relative treatment effect from aggregate-level data using event counts.
}
\examples{
ald <- data.frame(trt = c("B","C","B","C"),
                  variable = c(NA, NA, "y", "y"),
                  statistic = c("N", "N", "sum", "sum"),
                  value = c(100, 100, 50, 60))
                  
marginal_treatment_effect(ald, ref_trt = "C", comp_trt = "B",
                          scale = "log_odds", family = "binomial")
}
