% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{ds_write_ndjson}
\alias{ds_write_ndjson}
\title{Write FHIR data to NDJSON files}
\usage{
ds_write_ndjson(ds, path, save_mode = SaveMode$ERROR, file_name_mapper = NULL)
}
\arguments{
\item{ds}{The DataSource object.}

\item{path}{The URI of the directory to write the files to.}

\item{save_mode}{The save mode to use when writing the data.}

\item{file_name_mapper}{An optional function that can be used to customise the mapping
of the resource type to the file name. Currently not implemented.}
}
\value{
A list with element \code{file_infos}, containing a list of files created.
  Each file has \code{fhir_resource_type} and \code{absolute_url}.
}
\description{
Writes the data from a data source to a directory of NDJSON files. The files will be named using
the resource type and the ".ndjson" extension.
}
\examples{
\dontrun{
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))

# Write the data to a directory of NDJSON files.
data_source \%>\% ds_write_ndjson(file.path(tempdir(), "ndjson"))
}

}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#ndjson-1}{Pathling documentation - Writing NDJSON}

Other data sink functions: 
\code{\link{ds_write_delta}()},
\code{\link{ds_write_parquet}()},
\code{\link{ds_write_tables}()}
}
\concept{data sink functions}
