% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pervasive_dic_glm.R
\name{pervasive_dic_glm}
\alias{pervasive_dic_glm}
\title{Association Rule Mining With Dichotomized Data}
\usage{
pervasive_dic_glm(formula, data, min_support = 0.03)
}
\arguments{
\item{formula}{A formula specifying the dependent and independent variables.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{min_support}{The minimum proportion of rows that a rule must have to be considered for top rules.}
}
\value{
@return A list with the following components:
\itemize{
\item \code{OPCP}: Observed proportion of concordant pairs.
\item \code{adj_r_squared}: Adjusted R-squared value for the regression model.
\item \code{exact_match_lhs}, \code{exact_match_rhs}: The left and right-hand side of the rule suggested by the regression model, respectively
\item \code{exact_match_quality}: Quality metrics for the rule suggested by the regression.
\item \code{exact_match_lhs_opp}, \code{exact_match_rhs_opp}: The left and right-hand side of the rule suggested by the low end of the regression model, respectively
\item \code{exact_match_quality_opp}: Quality metrics for the rule suggested by the low end of the regression.
\item \code{top_rule_lhs}, \code{top_rule_rhs}, \code{top_rule_quality}: Information relevant to the highest lift rule meeting min_support for high values of the dependent variable.
\item \code{top_rule_opp_lhs}, \code{top_rule_opp_rhs}, \code{top_rule_opp_quality}: Information relevant to the highest lift rule meeting min_support for low values of the dependent variable.
\item \code{quality_table}: A table summarizing the quality statistics for extracted association rules.
\item \code{freq_tables}: Frequency tables (cutoffs and membership) for dichotomization binning.
}
}
\description{
This function provides similar information as pervasive_dic() and pervasive_tric() but should be the preferred option when the outcome variable is binary.
}
\examples{
# Example using the spi dataset from the psychTools package
sc <- psych::scoreVeryFast(psychTools::spi.keys, psychTools::spi)
spi_sc <- cbind(psychTools::spi, sc)
spi_sc_vars <- spi_sc |>
  dplyr::select(sex, Agree, Consc, Neuro, Extra, Open)
spi_sc_vars$sex = spi_sc_vars$sex -1

formula <- sex ~ Agree + Consc + Neuro + Extra + Open
example <- pervasive_dic_glm(formula = formula, data = spi_sc_vars)
example

}
