% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pervasive_tric.R
\name{pervasive_tric}
\alias{pervasive_tric}
\title{Association Rule Mining With Trichotomized Data}
\usage{
pervasive_tric(formula, data, min_support = 0.03)
}
\arguments{
\item{formula}{A formula specifying the dependent and independent variables.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{min_support}{The minimum proportion of rows that a rule must have to be considered for top rules.}
}
\value{
@return A list with the following components:
\itemize{
\item \code{OPCP}: Observed proportion of concordant pairs.
\item \code{adj_r_squared}: Adjusted R-squared value for the regression model.
\item \code{exact_match_lhs}, \code{exact_match_rhs}: The left and right-hand side of the rule suggested by the regression model, respectively
\item \code{exact_match_quality}: Quality metrics for the rule suggested by the regression.
\item \code{exact_match_lhs_opp}, \code{exact_match_rhs_opp}: The left and right-hand side of the rule suggested by the low end of the regression model, respectively
\item \code{exact_match_quality_opp}: Quality metrics for the rule suggested by the low end of the regression.
\item \code{top_rule_lhs}, \code{top_rule_rhs}, \code{top_rule_quality}: Information relevant to the highest lift rule meeting min_support for high values of the dependent variable.
\item \code{top_rule_opp_lhs}, \code{top_rule_opp_rhs}, \code{top_rule_opp_quality}: Information relevant to the highest lift rule meeting min_support for low values of the dependent variable.
\item \code{quality_table}: A table summarizing the quality statistics for extracted association rules.
\item \code{freq_tables}: Frequency tables (cutoffs and membership) for trichotomization binning.
}
}
\description{
This function extracts a specific set of association rules and reports quality measures for these rules. The OPCP and adjusted R-square for the regression model analyzed are also reported for a fuller pervasiveness context of the regression.
}
\examples{
# Example using the spi dataset from the psychTools package
sc <- psych::scoreVeryFast(psychTools::spi.keys, psychTools::spi)
spi_sc <- cbind(psychTools::spi, sc)
spi_sc_vars <- spi_sc |>
  dplyr::select(age, Agree, Consc, Neuro, Extra, Open)

formula <- age ~ Agree + Consc + Neuro + Extra + Open
example <- pervasive_tric(formula = formula, data = spi_sc_vars)
#From the results, it appears we would be rather unlikely to meet individuals
#with the patterns of personality traits suggested for old and young people
#by a linear regression when data is trichotomized.

example

}
