% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{check_wl_stepsize}
\alias{check_wl_stepsize}
\title{Check consistency of wavelength step size}
\usage{
check_wl_stepsize(x, span = Inf, na.rm = FALSE, min.stepsize = 1)
}
\arguments{
\item{x}{numeric vector.}

\item{span}{odd positive integer A peak is defined as an element in a
sequence which is greater than all other elements within a moving window of
width \code{span} centred at that element. The default value is 5, meaning
that a peak is taller than its four nearest neighbours. \code{span = NULL}
extends the span to the whole length of \code{x}.}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before searching for peaks.}

\item{min.stepsize}{numeric The minimum wavelength step size in nanometres
to use for comparison to the longest one.}
}
\value{
A logical \code{TRUE} is returned invisibly if check is passed and
  otherwise \code{FALSE} with a warning. A warning is issued on failure as
  a side effect.
}
\description{
Check the spread of wavelength step sizes in an ordered \code{numeric}
vector, or in the \code{"w.length"} column of a spectral object containing
a single spectrum.
}
\details{
As the search for peaks uses a window based on a fixed number of
  observations at neighbouring wavelengths, if the wavelength step between
  observations varies drastically, the window expressed in nanometres of
  wavelength becomes very irregular. With the default \code{span = 5} in
  \code{peaks()}, \code{valleys()}, and \code{wls_at_target()} the
  search in most cases still works for "thinned" spectra, and the check is
  skipped. With \code{spikes()} and \code{despike()} methods the check is
  always done as these methods do not override \code{span = Inf}.

  The typical case when the step can vary strongly are spectra returned by
  \code{thin_wl()}. As when using default arguments, including
  \code{span = 21}, \code{thin_wl()} retains the original local maxima and
  global maximum, and a reasonably narrow wavelength maximum step a call
  to \code{peaks} with \code{span = NULL} or \code{span = 5} \emph{tends}
  to discover the original peaks missing at most a few.
}
\examples{

check_wl_stepsize(sun.spct)
check_wl_stepsize(c(1:20, 25), span = 30)
check_wl_stepsize(1:20, span = 30, min.stepsize = 4)

}
