% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Replace_Rand.R
\name{Replace_Rand}
\alias{Replace_Rand}
\title{Select the new F matrix element with lowest error in the steepest
descent algorithm. Randomly modifies a single element and checks if the
modification reduces the error.}
\usage{
Replace_Rand(Fmat, i, S, cm, min.scaler, max.scaler)
}
\arguments{
\item{Fmat}{A list containing the F matrix, RMSE, and other components}

\item{i}{The index of the element to modify in the F matrix}

\item{S}{Sample data matrix - matrix of pigment samples}

\item{cm}{A vector of bounded weights for each pigment}

\item{min.scaler}{Minimum scaling factor to apply (e.g., 0.99 for 1\% decrease)}

\item{max.scaler}{Maximum scaling factor to apply (e.g., 1.01 for 1\% increase)}
}
\value{
A list containing:
\item{F matrix}{The modified F matrix}
\item{RMSE}{Root mean square error of the new solution}
\item{C matrix}{The concentration matrix}
\item{Improved}{Logical indicating if the modification reduced error}
}
\description{
Select the new F matrix element with lowest error in the steepest
descent algorithm. Randomly modifies a single element and checks if the
modification reduces the error.
}
\examples{
 # Setup based on Fac_F_RR usage
 Fmat <- as.matrix(phytoclass::Fm)
 S <- as.matrix(phytoclass::Sm)
 cm <- as.numeric(phytoclass:::Bounded_weights(S))

 # Get Fmat as a list from NNLS_MF (as used in Fac_F_RR)
 Fmat_list <- phytoclass::NNLS_MF(Fmat, S, cm)

 # Test with a single index
 i <- 1 # first non-zero element to modify
 min.scaler <- 0.99
 max.scaler <- 1.01

 # Run Replace_Rand
 result <- phytoclass:::Replace_Rand(Fmat_list, i, S, cm, min.scaler, max.scaler)
}
\keyword{internal}
