% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.piar_index.R
\name{window.piar_index}
\alias{window.piar_index}
\alias{window<-.piar_index}
\title{Index window}
\usage{
\method{window}{piar_index}(x, start = NULL, end = NULL, ...)

\method{window}{piar_index}(x, start = NULL, end = NULL, ...) <- value
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elementary_index]{elementary_index()}}.}

\item{start}{The time period to start the window. The default in the first
period of \code{x}.}

\item{end}{The time period to end the window. The default is the last period
of \code{x}.}

\item{...}{Not currently used.}

\item{value}{A numeric vector or price index.}
}
\value{
\code{window()} extracts a price index over a window of time periods that
inherits from the same class as \code{x}. The replacement method replaces these
with \code{value}.
}
\description{
Extract and replace index values over a window of time periods.
}
\examples{
x <- as_index(matrix(1:9, 3))

window(x, "2")

window(x, "2") <- 1
x

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{is.na.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()}
}
\concept{index methods}
