% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_4pl.R
\name{logistic_4pl}
\alias{logistic_4pl}
\title{4PL Logistic Dose-Response Model (Emax/Imax)}
\arguments{
\item{data}{A data frame containing dose-response experimental data.}

\item{dose_col}{Character string specifying the column name for dose.}

\item{response_col}{Character string specifying the column name for measured response.}

\item{group_col}{Optional character string specifying a column for grouping.}

\item{log_dose}{Logical; if TRUE, dose values are log10-transformed for plotting.}

\item{plot}{Logical; if TRUE, generates a dose-response plot with fitted 4PL curves.}

\item{annotate}{Logical; if TRUE, annotates the plot with model parameters and fit metrics.}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with E_min, E_max, EC50, n, RMSE, AIC, and BIC for each group.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Fits pharmacodynamic dose-response data to a 4-parameter logistic (4PL) model
using nonlinear least squares regression.

The model can handle **both increasing (Stimulatory / Emax)** and
**decreasing (Inhibitory / Imax)** dose-response curves automatically.

The 4PL model generalizes the Hill/Sigmoid model:

\deqn{
  E = E_{min} + \frac{E_{max} - E_{min}}{1 + (EC_{50} / D)^n} \quad \text{for increasing curves}
}

\deqn{
  E = E_{min} + \frac{E_{max} - E_{min}}{1 + (D / IC_{50})^n} \quad \text{for decreasing curves}
}

Key features:
* Automatically detects increasing vs decreasing responses
* \eqn{E_{min}} = minimum response (floor)
* \eqn{E_{max}} = maximum response (ceiling)
* \eqn{EC_{50}/IC_{50}} = dose producing half-maximal effect
* \eqn{n} = Hill coefficient (steepness)
* Symmetric sigmoid curve about midpoint
}
\examples{
# Example I: Single increasing curve (Emax)
df_emax <- data.frame(
  dose = c(0.1, 0.3, 1, 3, 10, 30, 100),
  response = c(5, 12, 28, 55, 75, 90, 98)
)
logistic_4pl(
  data = df_emax,
  dose_col = "dose",
  response_col = "response"
)

# Example II: Single decreasing curve (Imax)
df_imax <- data.frame(
  dose = c(0.1, 0.3, 1, 3, 10, 30, 100),
  response = c(95, 88, 70, 50, 30, 15, 5)
)
logistic_4pl(
  data = df_imax,
  dose_col = "dose",
  response_col = "response"
)

# Example III: Two treatment groups, mixed Emax/Imax
df_groups <- data.frame(
  dose = rep(c(0.1, 0.3, 1, 3, 10, 30), 2),
  response = c(
    4, 10, 25, 55, 78, 92,   # Group A: increasing (Emax)
    90, 75, 55, 35, 20, 10   # Group B: decreasing (Imax)
  ),
  treatment = rep(c("Group A", "Group B"), each = 6)
)
logistic_4pl(
  data = df_groups,
  dose_col = "dose",
  response_col = "response",
  group_col = "treatment",
  log_dose = TRUE
)
}
\references{
Holford, N. H. G. & Sheiner, L. B. (1981) <doi:10.2165/00003088-198106060-00002>
Understanding the dose-effect relationship. Clinical Pharmacokinetics, 6(6), 429–453.

Finney, D. J. (1971) <isbn:9780521080415> Probit Analysis, 3rd Edition.
Cambridge University Press, Cambridge.
}
\author{
Paul Angelo C. Manlapaz
}
