% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sumstats.R
\name{read_sumstats}
\alias{read_sumstats}
\title{Read summary statistics from either internal or external file - refer to ldscr R package (https://github.com/mglev1n/ldscr)}
\usage{
read_sumstats(munged_sumstats, name)
}
\arguments{
\item{munged_sumstats}{Either a dataframe, or a path to a file containing munged summary statistics. Must contain at least columns named `SNP` (rsid), `A1` (effect allele), `A2` (non-effect allele), `N` (total sample size) and `Z` (Z-score)}

\item{name}{trait name}
}
\value{
A data frame (tibble) containing GWAS summary statistics for the specified trait.
The returned object will always contain at least the following columns:
\itemize{
  \item \code{SNP}: SNP identifier (rsID).
  \item \code{A1}: Effect allele.
  \item \code{A2}: Non-effect allele.
  \item \code{N}: Total sample size for the SNP.
  \item \code{Z}: Z-score of SNP-trait association.
}
}
\description{
`read_sumstats()` Read summary statistics from either internal or external file
}
