% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.imdanovaFilt}
\alias{plot.imdanovaFilt}
\title{Plot imdanovaFilt Object}
\usage{
\method{plot}{imdanovaFilt}(
  x,
  min_nonmiss_anova = NULL,
  min_nonmiss_gtest = NULL,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 0,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  point_size = 3,
  line_size = 0.75,
  text_size = 3,
  bw_theme = TRUE,
  palette = NULL,
  display_count = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class imdanovaFilt (also a data frame) containing
the molecule identifier and number of samples in each group with
non-missing values for that molecule}

\item{min_nonmiss_anova}{An integer indicating the minimum number of
non-missing feature values allowed per group for \code{anova_filter}.
Suggested value is 2.}

\item{min_nonmiss_gtest}{An integer indicating the minimum number of
non-missing feature values allowed per group for \code{gtest_filter}.
Suggested value is 3.}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label}

\item{y_lab}{character string specifying the y-axis label}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is 0.}

\item{title_lab}{character string specifying the plot title.}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title.}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{point_size}{integer specifying the size of the points. The default
is 3.}

\item{line_size}{integer specifying the thickness of the line. The default
is 0.75.}

\item{text_size}{integer specifying the size of the text (number of
biomolecules per group). The default is 3.}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{display_count}{logical value. Indicates whether the missing value counts by
sample will be displayed on the bar plot. The default is TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'imdanovaFilt'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
data(pep_object)
mypep <- group_designation(omicsData = pep_object, main_effects = "Phenotype")
to_filter <- imdanova_filter(omicsData = mypep)
plot(to_filter, min_nonmiss_anova = 2, min_nonmiss_gtest = 3)
\dontshow{\}) # examplesIf}
}
