% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_summary.R
\name{summary.proteomicsFilt}
\alias{summary.proteomicsFilt}
\title{Proteomics Filter Summary}
\usage{
\method{summary}{proteomicsFilt}(object, min_num_peps = NULL, redundancy = FALSE, ...)
}
\arguments{
\item{object}{S3 object of class 'proteomicsFilt' created by
\code{\link{proteomics_filter}}.}

\item{min_num_peps}{optional integer value between 1 and the maximum
number of peptides that map to a protein in the data. The value specifies
the minimum number of peptides that must map to a protein. Any protein with
less than \code{min_num_peps} mapping to it will be returned as a protein
that should be filtered. Default value is NULL.}

\item{redundancy}{logical indicator of whether to filter out 'degenerate' or 'redundant'
peptides (i.e. peptides mapping to multiple proteins) (TRUE) or not
(FALSE). Default value is FALSE.}

\item{...}{further arguments passed to or from other methods}
}
\value{
a summary table giving the number of Observed Proteins per Peptide
  and number of Observed Peptides per Protein. If min_num_peps is specified
  and/or redundancy is TRUE, the number of biomolecules to be filtered with
  the specified threshold(s) are reported.
}
\description{
Provide summary of a proteomicsFilt S3 object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
myfilt <- proteomics_filter(omicsData = pep_object)
summary(myfilt, redundancy = TRUE) # there are no degenerate peptides to filter out
summary(myfilt, min_num_peps = 2)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{proteomics_filter}}
}
\author{
Lisa Bramer
}
