% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.pmrm_fit}
\alias{plot.pmrm_fit}
\title{Plot a fitted PMRM.}
\usage{
\method{plot}{pmrm_fit}(
  x,
  y = NULL,
  ...,
  confidence = 0.95,
  show_data = TRUE,
  show_marginals = TRUE,
  show_predictions = FALSE,
  facet = TRUE,
  alpha = 0.25
)
}
\arguments{
\item{x}{A fitted model object of class \code{"pmrm_fit"} returned
by a \code{pmrm} model-fitting function.}

\item{y}{Not used.}

\item{...}{Not used.}

\item{confidence}{Numeric between 0 and 1, the confidence level
to use in the 2-sided confidence intervals.}

\item{show_data}{\code{TRUE} to plot data-based visit-specific data means and
confidence intervals as boxes.
\code{FALSE} to omit.}

\item{show_marginals}{\code{TRUE} to plot model-based confidence intervals
and estimates of marginal means as boxes and horizontal lines
within those boxes, respectively.
Uses \code{\link[=pmrm_marginals]{pmrm_marginals()}} with the given level of confidence.
\code{FALSE} to omit.}

\item{show_predictions}{\code{TRUE} to plot expected outcomes and confidence
bands with lines and shaded regions, respectively.
Uses \code{\link[=predict.pmrm_fit]{predict.pmrm_fit()}} with \code{adjust = FALSE} and
the given level of confidence
on the original dataset used to fit the model.
Predictions on a full dataset are generally slow,
so the default is \code{FALSE}.}

\item{facet}{\code{TRUE} to facet the plot by study arm,
\code{FALSE} to overlay everything in a single panel.}

\item{alpha}{Numeric between 0 and 1, opacity level of the
model-based confidence bands.}
}
\value{
A \code{ggplot} object with the plot.
}
\description{
Plot a fitted progression model for repeated measures (PMRM)
against the data.
}
\details{
The plot shows the following elements:
\itemize{
\item Raw estimates and confidence intervals on the data, as boxes
(if \code{show_data} is \code{TRUE}).
\item Model-based estimates and confidence intervals as points and error
bars, respectively
(if \code{show_marginals} is \code{TRUE}).
\item Continuous model-based estimates and confidence bands as lines
and shaded regions, respectively
(if \code{show_predictions} is \code{TRUE}).
}
}
\examples{
  set.seed(0L)
  simulation <- pmrm_simulate_decline_proportional(
    visit_times = seq_len(5L) - 1,
    gamma = c(1, 2)
  )
  fit <- pmrm_model_decline_proportional(
    data = simulation,
    outcome = "y",
    time = "t",
    patient = "patient",
    visit = "visit",
    arm = "arm",
    covariates = ~ w_1 + w_2
  )
  plot(fit)
}
\seealso{
Other visualization: 
\code{\link{print.pmrm_fit}()}
}
\concept{visualization}
