% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_nm.R
\name{run_nm}
\alias{run_nm}
\title{Run NONMEM from R}
\usage{
run_nm(
  ctl_file,
  nm_path,
  parralel_command = NULL,
  create_dir = TRUE,
  data_file = NULL
)
}
\arguments{
\item{ctl_file}{(string) Absolute or relative Path/Name of NONMEM file to run. Must be in R-style, i.e., path must be with
slashes. File must be given with file extension, e.g., nonmem_file\strong{.ctl}}

\item{nm_path}{(string) Absolute or relative Path/Name of NONMEM to be executed, \cr
e.g., "C:/nm75g64/run/nmfe75".}

\item{parralel_command}{(string) (Optional) Command for parralel NONMEM execution, \cr
e.g., "-parafile=C:/nm75g64/run/mpiwini8.pnm [nodes]=30"}

\item{create_dir}{(boolean) If NONMEM file should be run and saved in new directory. If TRUE, new directory of type 
\emph{path_to_ctl_file/ctl_name} will be created. Default is TRUE.}

\item{data_file}{(string) Absolute or relative Path/Name of data file to be used in the NONMEM run. Required if \emph{create_dir=}TRUE
as data file will be copied to new directory.}
}
\value{
No return value, running the specified model in NONMEM via command line.
}
\description{
Runs NONMEM from R
}
\details{
All paths must be given in R-style, i.e., slashes instead of backslashes. Paths can be absolute or relative.
}
\examples{
\dontrun{
run_nm("./test/nm_test.ctl","c:/nm75g64/run/nmfe75",
       parralel_command = "-parafile=C:/nm75g64/run/mpiwini8.pnm [nodes]=30",
       data_file="~/Test/test/test_data.csv")
}
}
\author{
Dominic Bräm
}
