% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_columns_from_tbl}
\alias{info_columns_from_tbl}
\title{Add column information from another data table}
\usage{
info_columns_from_tbl(x, tbl, .add = TRUE)
}
\arguments{
\item{x}{\emph{The pointblank informant object}

\verb{obj:<ptblank_informant>} // \strong{required}

A \strong{pointblank} \emph{informant} object that is commonly created through the
use of the \code{\link[=create_informant]{create_informant()}} function.}

\item{tbl}{\emph{Metadata table with column information}

\verb{obj:<tbl_*>} // \strong{required}

The two-column data frame which contains metadata about the target table in
the informant object.}

\item{.add}{\emph{Add to existing info text}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should new text be added to existing text? This is \code{TRUE} by default;
setting to \code{FALSE} replaces any existing text for the \code{"info"} property.}
}
\value{
A \code{ptblank_informant} object.
}
\description{
The \code{info_columns_from_tbl()} function is a wrapper around the
\code{\link[=info_columns]{info_columns()}} function and is useful if you wish to apply \emph{info text} to
columns where that information already exists in a data frame (or in some
form that can readily be coaxed into a data frame). The form of the input
\code{tbl} (the one that contains column metadata) has a few basic requirements:
\itemize{
\item the data frame must have two columns
\item both columns must be of class \code{character}
\item the first column should contain column names and the second should contain
the \emph{info text}
}

Each column that matches across tables (i.e., the \code{tbl} and the target table
of the informant) will have a new entry for the \code{"info"} property. Empty or
missing info text will be pruned from \code{tbl}.
}
\section{Examples}{


Create a pointblank \code{informant} object with \code{\link[=create_informant]{create_informant()}}. We can
specify a \code{tbl} with the \code{~} followed by a statement that gets the
\code{game_revenue} dataset.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  create_informant(
    tbl = ~ game_revenue,
    tbl_name = "game_revenue",
    label = "An example."
  )
}\if{html}{\out{</div>}}

We can add \emph{info text} to describe the data in the various columns of the
table by using \code{\link[=info_columns]{info_columns()}} or information in another table (with
\code{\link[=info_columns_from_tbl]{info_columns_from_tbl()}}). Here, we'll do the latter. The
\code{game_revenue_info} dataset is included in \strong{pointblank} and it contains
metadata for \code{game_revenue}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{game_revenue_info
#> # A tibble: 11 x 2
#>    column           info                                                        
#>    <chr>            <chr>                                                       
#>  1 player_id        A `character` column with unique identifiers for each user/~
#>  2 session_id       A `character` column that contains unique identifiers for e~
#>  3 session_start    A date-time column that indicates when the session (contain~
#>  4 time             A date-time column that indicates exactly when the player p~
#>  5 item_type        A `character` column that provides the class of the item pu~
#>  6 item_name        A `character` column that provides the name of the item pur~
#>  7 item_revenue     A `numeric` column with the revenue amounts per item purcha~
#>  8 session_duration A `numeric` column that states the length of the session (i~
#>  9 start_day        A `Date` column that provides the date of first login for t~
#> 10 acquisition      A `character` column that provides the method of acquisitio~
#> 11 country          A `character` column that provides the probable country of ~
}\if{html}{\out{</div>}}

The \code{info_columns_from_tbl()} function takes a table object where the first
column has the column names and the second contains the \emph{info text}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  informant \%>\%
  info_columns_from_tbl(tbl = game_revenue_info)
}\if{html}{\out{</div>}}

Upon printing the \code{informant} object, we see the additions made to the
'Columns' section by the \code{info_columns_from_tbl(tbl = game_revenue_info)}
call.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_info_columns_from_tbl_1.png" alt="This image was generated from the first code example in the `info_columns_from_tbl()` help file." style="width:100\%;">
}
}

We can continue to add more \emph{info text} to describe the columns since the
process is additive. The \code{info_columns_from_tbl()} function populates the
\code{info} subsection and any calls of \code{\link[=info_columns]{info_columns()}} that also target a \code{info}
subsection will append text. Here, we'll add content for the \code{item_revenue}
and \code{acquisition} columns and view the updated report.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <-
  informant \%>\%
  info_columns(
    columns = item_revenue,
    info = "Revenue reported in USD."
  ) \%>\%
  info_columns(
    columns = acquisition,
    `top list` = "\{top5_aq\}"
  ) \%>\%
  info_snippet(
    snippet_name = "top5_aq",
    fn = snip_list(column = "acquisition")
  ) \%>\%
  incorporate()

informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_info_columns_from_tbl_2.png" alt="This image was generated from the second code example in the `info_columns_from_tbl()` help file." style="width:100\%;">
}
}
}

\section{Function ID}{

3-3
}

\seealso{
The \code{\link[=info_columns]{info_columns()}} function, which allows for manual entry of
\emph{info text}.

Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_snippet}()},
\code{\link{info_tabular}()},
\code{\link{snip_highest}()},
\code{\link{snip_list}()},
\code{\link{snip_lowest}()},
\code{\link{snip_stats}()}
}
\concept{Information Functions}
