% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_boot.R
\name{gen_boot}
\alias{gen_boot}
\title{Generate Bootstrap Estimates}
\usage{
gen_boot(
  fit_all,
  R = 100,
  ...,
  iseed = NULL,
  parallel = FALSE,
  progress = FALSE,
  ncores = max(1, parallel::detectCores(logical = FALSE) - 1),
  compute_implied_stats = FALSE
)
}
\arguments{
\item{fit_all}{The output of
\code{\link[=fit_model]{fit_model()}} or an object of the
class \code{fit_out}.}

\item{R}{The number of replications
to generate the bootstrap estimates
for each fit output.}

\item{...}{Optional arguments to be
passed to \code{\link[manymome:do_boot]{manymome::do_boot()}} when
generating the bootstrap estimates.}

\item{iseed}{The seed for the random
number generator. Default is \code{NULL}
and the seed is not changed.}

\item{parallel}{If \code{TRUE}, parallel
processing will be used to generate
bootstrap estimates for the
fit outputs. Default is \code{FALSE}.}

\item{progress}{If \code{TRUE}, the progress
will be displayed.
Default is `FALSE.}

\item{ncores}{The number of CPU
cores to use if parallel processing
is used.}

\item{compute_implied_stats}{Whether
implied statistics are computed
in each bootstrap samples. Usually
not needed and so default to \code{FALSE}}
}
\value{
A \code{boot_list} object, which is a list
of the output of \code{\link[manymome:do_boot]{manymome::do_boot()}}.
}
\description{
Get a list of the output
of \code{\link[lavaan:sem]{lavaan::sem()}} or \code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}
and generate
bootstrap estimates of model
parameters.
}
\details{
The function \code{\link[=gen_boot]{gen_boot()}}
simply calls \code{\link[manymome:do_boot]{manymome::do_boot()}}
on each output of
\code{\link[lavaan:sem]{lavaan::sem()}} or \code{\link[lmhelprs:many_lm]{lmhelprs::many_lm()}}
in \code{fit_all}. The
simulated
estimates can then be used to test
effects such as indirect effects,
usually by functions from the
\code{manymome} package, such as
\code{\link[manymome:cond_indirect]{manymome::indirect_effect()}}.
}
\section{The role of \code{gen_boot()}}{
This function is used by the
all-in-one function \code{\link[=power4test]{power4test()}}.
Users usually do not call this
function directly, though
developers can use this function to
customize the workflow of the
power analysis.
}

\examples{

# Specify the population model

mod <-
"m ~ x
 y ~ m + x"

# Specify the effect sizes (population parameter values)

es <-
"
y ~ m: m
m ~ x: m
y ~ x: n
"

# Generate several simulated datasets

data_all <- sim_data(nrep = 2,
                     model = mod,
                     pop_es = es,
                     n = 50,
                     iseed = 1234)

# Fit the population model to each datasets

fit_all <- fit_model(data_all)

# Generate bootstrap estimates for each replication

boot_all <- gen_boot(fit_all,
                     R = 10,
                     iseed = 4567)
boot_all


}
\seealso{
See \code{\link[=power4test]{power4test()}} for
the all-in-one function that uses
this function.
}
