\name{simpson}
\alias{simpson}
\title{
  Simpson Integration
}
\description{
  Numerically evaluate an integral by Simpson's rule.
}
\usage{
simpson(f, a, b, n = 100, ...)
}
\arguments{
  \item{f}{function of one variable, the integrand.}
  \item{a, b}{left and right endpoint of the interval.}
  \item{n}{number of sub-intervals, default 100.}
  \item{\ldots}{additional parameters to be passed to the integrand.}
}
\details{
  Simpson's rule calculates an integral of a function of one variable
  by approximating it quadratically. It is an easy to get and often quite
  accurate estimate. 
}
\value{
  Numerical scalar, the value of the integral.
}
\note{
  This version has been generated by DeepSeek.
  For a non-vectorized function f use Vectorize(f)!
}
\seealso{
  \code{\link{simpson2d}}, \code{\link{simpadpt}}
}
\examples{
simpson(sin, 0, pi, n=100)      # 2.0000000108245
simpson(sin, 0, pi, n=1000)     # 2.0000000000011

# Can also be used for a discretized function ...
xs <- seq(0, pi, length.out = 101)
ys <- sin(xs)
# ... by a linear approximation of that function
f <- approxfun(xs, ys, method = "linear")
simpson(f, 0, pi, n = 100)      # 2.0000000108245
simpson(f, 0, pi, n = 1000)     # 1.9998355038874
trapz(xs, ys)                   # 1.9998355038875
}
\keyword{ math }
