% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_minmax.R
\name{norm_minmax}
\alias{norm_minmax}
\title{Min-Max Normalization}
\usage{
norm_minmax(x, min_val = 0, max_val = 1, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{min_val}{The minimum value of the target range. Default is 0.}

\item{max_val}{The maximum value of the target range. Default is 1.}

\item{na.rm}{Logical. Should NA values be removed during min/max calculation?
Default is \code{TRUE}.}
}
\value{
A numeric vector scaled to the range [min_val, max_val].
}
\description{
Scales a numeric vector to a specific range, typically [0, 1].
This method is sensitive to outliers.
}
\details{
Formula: \eqn{x' = \frac{x - \min(x)}{\max(x) - \min(x)} \times (\text{max\_val} - \text{min\_val}) + \text{min\_val}}
}
\examples{
norm_minmax(c(1, 2, 3, 4, 5))
norm_minmax(c(1, 2, 3), min_val = -1, max_val = 1)
}
\references{
Han, J., Kamber, M., & Pei, J. (2011). \emph{Data mining: concepts and techniques} (3rd ed.). Morgan Kaufmann.
}
